"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cors_1 = require("@fastify/cors");
const multipart_1 = require("@fastify/multipart");
const fastify_1 = require("fastify");
const fastify_type_provider_zod_1 = require("fastify-type-provider-zod");
const create_question_1 = require("./http/routes/create-question");
const create_room_1 = require("./http/routes/create-room");
const get_room_questions_1 = require("./http/routes/get-room-questions");
const get_rooms_1 = require("./http/routes/get-rooms");
const upload_audio_1 = require("./http/routes/upload-audio");
const app = (0, fastify_1.fastify)().withTypeProvider();
app.register(cors_1.fastifyCors, {
    origin: "http://localhost:5173",
});
app.register(multipart_1.fastifyMultipart);
app.setSerializerCompiler(fastify_type_provider_zod_1.serializerCompiler);
app.setValidatorCompiler(fastify_type_provider_zod_1.validatorCompiler);
app.get("/health", () => {
    return "OK";
});
app.register(get_rooms_1.getRoomsRoute);
app.register(create_room_1.createRoomRoute);
app.register(get_room_questions_1.getRoomQuestions);
app.register(create_question_1.createQuestionRoute);
app.register(upload_audio_1.uploadAudioRoute);
exports.default = app;
